﻿
-- Insert default values
-- Default: Callbacks Leeway period (0=none), Reassign code (''=none) and Last Job Execution time stamp (=now )
if ( (select count(*) from Installation where INSSECTION = 'CALLBACKS' AND INSIDENT = 'LEEWAY_PERIOD') = 0 )
BEGIN
	INSERT INTO [Installation] ([INSSECTION],[INSIDENT],[INSVALUE],[projectId],[modifiedBy],[modified])
	VALUES ('CALLBACKS','LEEWAY_PERIOD',0,0,0,GETUTCDATE() )
END;

if ( (select count(*) from Installation where INSSECTION = 'CALLBACKS' AND INSIDENT = 'REASSIGN_CODES') = 0 )
BEGIN
	INSERT INTO [Installation] ([INSSECTION],[INSIDENT],[INSVALUE],[projectId],[modifiedBy],[modified])
	VALUES ('CALLBACKS','REASSIGN_CODES','',0,0,GETUTCDATE() )
END;

if ( (select count(*) from Installation where INSSECTION = 'CALLBACKS' AND INSIDENT = 'LAST_REASSIGNMENT_JOB_TIME') = 0 )
BEGIN
	INSERT INTO [Installation] ([INSSECTION],[INSIDENT],[INSVALUE],[projectId],[modifiedBy],[modified])
	VALUES ('CALLBACKS','LAST_REASSIGNMENT_JOB_TIME',GETUTCDATE(),0,0,GETUTCDATE() )
END;
GO

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[TraceLog]') AND type in (N'U'))
BEGIN
	CREATE TABLE [dbo].[TraceLog](
		[TraceId] [bigint] NOT NULL,
		[TraceTime] [datetime2](7) NOT NULL,
		[TraceStep] [int] NULL,
		[TraceMessage] [nvarchar](255) NULL,
	) ON [PRIMARY]

	CREATE NONCLUSTERED INDEX [IX_Table_IdxTimeStamp] ON [dbo].[TraceLog]
	(
		[TraceId] ASC,
		[TraceTime] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	CREATE NONCLUSTERED INDEX [IX_Table_TimeStamp] ON [dbo].[TraceLog]
	(
		[TraceTime] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
END
GO


